package AppGioco.Quadro;

import java.util.*;

import AppGioco.*;

public class Quadro {
	protected String fileAmbientazione;
	protected HashSet<TipoLinkGiocato> giocato;

	public Quadro(String fa) {
		fileAmbientazione = fa;
		giocato = new HashSet<TipoLinkGiocato>();
	}

	public String getFileAmbientazione() {
		return fileAmbientazione;
	}

	public void setFileAmbientazione(String fa) {
		fileAmbientazione = fa;
	}
	public void inserisciLinkGiocato(TipoLinkGiocato t) {
		if (t != null && t.getQuadro()==this)
			ManagerGiocato.inserisci(t);
	}

	public void eliminaLinkGiocato(TipoLinkGiocato t) {
		if (t != null && t.getQuadro()==this)
			ManagerGiocato.elimina(t);
	}
	public void inserisciPerManagerGiocato(ManagerGiocato a) {
		if (a != null)
			giocato.add(a.getLink());
	}

	public void eliminaPerManagerGiocato(ManagerGiocato a) {
		if (a != null)
			giocato.remove(a.getLink());
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkGiocato> getLinkGiocato() {
		return (HashSet<TipoLinkGiocato>) giocato.clone();
	}
}
